# import library
import tkinter as tk
import tkinter.ttk as ttk
import socket, time, os, random, qrcode, base64, io, string
from contextlib import suppress


def Validate():
    global click_count

    if user_input.get() == "" or not user_input.get().isdecimal():
        result_color.set('antiquewhite2')
        result.set('Please enter a valid response.')
    elif int(user_input.get()) == int(code_qr) or os.path.isfile(f'C:/SCCM_remedy/code/{user_input.get()}') or \
            int(user_input.get()) == int(code_rand):
        result_color.set('light green')
        result.set('The entered code is valid. Changes, if any, will be applied.')
        os.system('cmd /c "netsh ipsec static set policy name=LAN assign=n"')
        validation.configure(state='disabled')
        entered.delete(0, 'end')
        entered.configure(state='disabled')
    elif int(user_input.get()) == int(code_rem):
        result_color.set('dark green')
        result.set('The entered code is valid. Changes, if any, will be applied.')
        os.system('cmd /c "netsh ipsec static set policy name=LAN assign=n"')
        time.sleep(5)
        os.system('cmd /c "netsh ipsec static delete policy LAN"')
        validation.configure(state='disabled')
        entered.delete(0, 'end')
        entered.configure(state='disabled')
    else:
        result_color.set('red')
        result.set('The entered code is invalid. No changes have been applied.')

    feedback.configure(disabledbackground=result_color.get())

    click_count += 1
    if click_count > 10:
        Reset()


def Reset():
    global click_count

    result.set("")
    user_input.set("")
    result_color.set('antiquewhite2')
    feedback.configure(disabledbackground=result_color.get())
    the_challenge.destroy()
    informed.destroy()
    click_count = 0

    root.quit()


def QR(var):
    global validate_value

    def on_closing():
        entered.configure(state='normal')
        entered.delete(0, 'end')
        refresh.configure(state='normal')
        validation.configure(state='normal')
        the_challenge.configure(text=f'Challenge: {code_disp}')
        qr_window.destroy()

    validate_value = var.get()
    var.set(validate_value)
    if validate_value != os.getlogin():
        return
    else:
        entered.configure(state='disabled')

    input_data = f'{code64}'

    qr = qrcode.QRCode(version=1, box_size=10, border=5)
    qr.add_data(input_data)
    qr.make(fit=True)
    img = qr.make_image(fill='black', back_color='white')

    buffered = io.BytesIO()
    img.save(buffered, format="PNG")
    img_str = base64.b64encode(buffered.getvalue())
    img_insert = tk.PhotoImage(data=img_str)
    dimensions = "image size: %dx%d" % (img_insert.width(), img_insert.height())

    qr_window = tk.Toplevel(root)
    qr_window.title("QR Code")
    qr_window.geometry()
    qr_window.resizable(0, 0)
    qr_window.config(bg='lightgrey')
    qr_window.attributes('-topmost', True)

    tk.Label(qr_window, text='The below QR is for "self service" code generation. Using a phone that can scan QR codes'
                             ' will generate the email format you need to send. From your phone, create a new email and'
                             ' populate with the given information and send to abc@abcdefg.com. You will receive a'
                             ' reply within 10 minutes containing your response code.', wraplength=dimensions[12:15],
             justify='left', font='arial 11 bold', bg='light grey').pack()
    tk.Label(qr_window, image=img_insert).pack()

    qr_window.protocol("WM_DELETE_WINDOW", on_closing)
    refresh.configure(state='disabled')
    validation.configure(state='disabled')
    the_challenge.configure(text='Challenge: QR')


def Info():
    def on_closing():
        info_butt.configure(state='normal')
        info_window.destroy()

    def what_time():
        what_time_is_it = time.strftime('%Y-%m-%d %H:%M:%S')
        info_0.config(text=what_time_is_it)
        info_0.after(1000, what_time)

    info_window = tk.Toplevel(root)
    info_window.title("Information")
    info_window.geometry()
    info_window.resizable(0, 0)
    info_window.config(bg='lightgrey')
    info_window.attributes('-topmost', True)

    info_0 = tk.Label(info_window, padx=15, pady=15, font='arial 12 bold', fg='white', bg='light blue')
    info_0.pack(expand=True, fill='x', side='bottom')
    info_1 = tk.Label(info_window, text=f'Device name: {hostname}', anchor='w', padx=15, pady=5, font='arial 12 bold',
                      fg='green', bg='light blue')
    info_1.pack(expand=True, fill='x', side='top')
    info_2 = tk.Label(info_window, text=f'Logged on user: {whoami}', anchor='w', padx=15, pady=5, font='arial 12 bold',
                      fg='blue', bg='light blue')
    info_2.pack(expand=True, fill='x', side='top')
    info_3 = tk.Label(info_window, text=f'Device IP address: {ip}', anchor='w', padx=15, pady=5, font='arial 12 bold',
                      fg='red', bg='light blue')
    info_3.pack(expand=True, fill='x', side='top')

    info_window.protocol("WM_DELETE_WINDOW", on_closing)
    info_butt.configure(state='disabled')

    what_time()


def Exit():
    root.destroy()


click_count = 0
validate_value = ''

# initialize window
root = tk.Tk()
root.geometry('400x370')
root.resizable(0, 0)
root.title('Client Code Generator')
root.config(bg='lightgrey')

style = ttk.Style()
style.configure("Custom.TButton", foreground="black", background="white", padding=[5, 5, 5, 5], font="Verdana 12")

with suppress(Exception):
    while root.state() == 'normal':
        whoami = os.getlogin()
        hostname = socket.gethostname()

        ip = '0.0.0.0'
        for ip in socket.gethostbyname_ex(socket.gethostname())[2]:
            pass

        today = time.strftime('%Y%m%d')
        year = time.strftime('%Y')
        month = time.strftime('%m')
        day = time.strftime('%d')
        current_rand = int(year) * int(month) * int(day)
        current_rem = int(year) * int(month) * int(day)

        current_qr = 1
        for num in today:
            if int(num) == 0:
                continue
            current_qr *= int(num)

        challenge_qr = current_qr * current_rand
        challenge_rand = random.randint(1000, 9999)
        challenge_rem = 999999999

        challenge_dict = {'A': 15285, 'B': 68272, 'C': 58542, 'D': 22696, 'E': 44128, 'F': 88531, 'G': 66710, 'H': 21588,
                          'I': 44163, 'J': 94714, 'K': 52484, 'L': 66349, 'M': 78247, 'N': 15236, 'O': 44451, 'P': 34742,
                          'Q': 22333, 'R': 47858, 'S': 15821, 'T': 99610, 'U': 47232, 'V': 31742, 'W': 11127, 'X': 54726,
                          'Y': 74188, 'Z': 80491, '-': 99911, '.': 58261, '_': 77293, '$': 89432}

        code_disp = f'{hostname.upper()}{challenge_rand}'
        for char in code_disp:
            if char.isdecimal():
                current_rand += int(char)
            else:
                check = char.upper()
                current_rand += int(challenge_dict[f'{check}'])

        for char in f'{challenge_rem}':
            if char.isdecimal():
                current_rem += int(char)
            else:
                check = char.upper()
                current_rem += int(challenge_dict[f'{check}'])

        statement_1 = int(current_rand) * int(current_rand)
        statement_2 = int(current_rand) + int(current_rand)

        code64 = base64.b64encode(bytearray(f'{hostname}_{whoami}_{ip}_{challenge_qr}', 'ascii')).decode('utf-8')
        new_string = []
        new_string_num = 1
        for indx, value in enumerate(code64):
            for indx_2, value_2 in enumerate(string.printable):
                if value == value_2:
                    new_string.append(indx_2)
                    if not indx_2 == 0:
                        new_string_num += indx_2

        code_rand = statement_1 - statement_2
        code_qr = new_string_num * new_string_num
        code_rem = int(challenge_rem) * int(current_rem)

        #heading
        the_challenge = tk.Label(root, text=f'Challenge: {code_disp}', font='arial 14 bold', bg='light blue')
        the_challenge.pack(side='top', fill='both')
        informed = tk.Label(root, text='Contact GPT ICT on "011 241 0899" and provide the challenge above. '
                                       'A response will be generated for you.',
                            wraplength=400, justify="center", font='arial 11 bold', bg='light grey')
        informed.place(x=0, y=30)


        ###### Testing - can delete ######
        root.clipboard_clear()
        root.clipboard_append(code_disp)
        ###### Testing - can delete ######


        #user choice
        user_input = tk.StringVar()
        tk.Label(root, text='Enter Response', font='arial 15 bold', bg='grey80').place(x=125, y=105)
        entered = tk.Entry(root, font='arial 15', textvariable=user_input, state='normal', bg='white')
        entered.place(x=90, y=145)
        user_input.trace('w', lambda nm, idx, mode, var=user_input: QR(var))

        #function for validation
        result = tk.StringVar()
        result_color = tk.StringVar()
        result_color.set('antiquewhite2')

        #button
        feedback = tk.Entry(root, font='arial 10 bold', textvariable=result, state='disabled',
                            disabledbackground=result_color.get(), disabledforeground="black", width=55)
        feedback.place(x=5, y=250)

        validation = ttk.Button(root, text='VALIDATE', state='normal', style="Custom.TButton", command=Validate)
        validation.place(x=135, y=200)
        info_butt = ttk.Button(root, text='INFO', state='normal', style="Custom.TButton", command=Info)
        info_butt.place(x=250, y=285)
        refresh = ttk.Button(root, text='RESET', state='normal', style="Custom.TButton", command=Reset)
        refresh.place(x=25, y=285)
        ttk.Button(root, text='EXIT', style="Custom.TButton", command=Exit).place(x=140, y=325)

        root.mainloop()

